/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.model;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;

@JsonIgnoreType
public class BaseStringMap {
    protected static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected Map<String, String> map = new LinkedHashMap<String, String>();
    protected Map<String, String> caseMap = new HashMap<String, String>();

    public Set<String> getKeys() {
        return this.map.keySet();
    }

    public void unsetProperty(String key) {
        this.map.remove(key);
        this.caseMap.remove(key);
    }

    public void setPropertyTrim(String key, String val) {
        if (val != null) {
            val = val.trim();
        }
        this.setProperty(key, val);
    }

    public void setProperty(String key, String val) {
        this.map.put(key, val);
        this.caseMap.put(key.toLowerCase(), key);
    }

    public void setProperty(String key, Long val) {
        if (val != null) {
            this.setProperty(key, val.toString());
        } else {
            this.setProperty(key, (Long)null);
        }
    }

    public void setProperty(String key, Integer val) {
        if (val != null) {
            this.setProperty(key, val.toString());
        } else {
            this.setProperty(key, (String)null);
        }
    }

    public void setProperty(String key, Double val) {
        if (val != null) {
            this.setProperty(key, val.toString());
        } else {
            this.setProperty(key, (String)null);
        }
    }

    public void setProperty(String key, Boolean val) {
        if (val != null && val.booleanValue()) {
            this.setProperty(key, "1");
        } else {
            this.setProperty(key, "0");
        }
    }

    public void setProperty(String key, Date val) {
        if (val != null) {
            this.setProperty(key, sdf.format(val));
        } else {
            this.setProperty(key, (String)null);
        }
    }

    public String getProperty(String key) {
        String k = this.caseMap.get(key.toLowerCase());
        if (this.map.containsKey(k)) {
            return this.map.get(k);
        }
        return null;
    }

    public boolean hasProperty(String key) {
        return this.caseMap.containsKey(key.toLowerCase());
    }

    public Boolean getPropertyBool(String key) {
        String p = this.getProperty(key);
        if (p != null && ("1".equals(p) || "t".equalsIgnoreCase(p) || "true".equalsIgnoreCase(p) || "y".equalsIgnoreCase(p))) {
            return true;
        }
        return false;
    }

    public Integer getPropertyInt(String key) {
        String p = this.getProperty(key);
        if (p != null && p.matches("^-{0,1}[0-9]+$")) {
            return NumberUtil.tryParseInt(p);
        }
        return null;
    }

    public Long getPropertyLong(String key) {
        String p = this.getProperty(key);
        if (p != null && p.matches("^-{0,1}[0-9]+$")) {
            return NumberUtil.tryParseLong(p);
        }
        return null;
    }

    public Double getPropertyDouble(String key) {
        String p = this.getProperty(key);
        if (p != null) {
            return NumberUtil.tryParseDouble(p);
        }
        return null;
    }

    public Date getPropertyDate(String key) {
        return DateUtil.string2date(this.getProperty(key));
    }

    public Date getPropertyDateTime(String key) {
        String v = this.getProperty(key);
        if (v == null) {
            return null;
        }
        return DateUtil.string2datetime(v);
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public void setMap(Map<String, String> m) {
        this.map = m;
        this.caseMap = new HashMap<String, String>();
        for (String k : this.map.keySet()) {
            this.caseMap.put(k.toLowerCase(), k);
        }
    }

    public static List<Map> bsm2maplist(List<BaseStringMap> recs) {
        ArrayList<Map> maps = new ArrayList<Map>();
        int x = 0;
        while (x < recs.size()) {
            maps.add(recs.get(x).getMap());
            ++x;
        }
        return maps;
    }
}

